﻿using System;
using System.ComponentModel;
using System.ComponentModel.Design;
using System.Collections;
using System.Drawing;
using System.Linq;
using System.Workflow.ComponentModel.Compiler;
using System.Workflow.ComponentModel.Serialization;
using System.Workflow.ComponentModel;
using System.Workflow.ComponentModel.Design;
using System.Workflow.Runtime;
using System.Workflow.Activities;
using System.Workflow.Activities.Rules;

namespace Lessons.Workflows
{

    /*  a sequential workflow.
        
        Activities and the Activity class
        CodeActivity class
        SequenceActivity class
        DelayActivity class
        
        A workflow is a group of one or more activities.
        A sequential workflow executes its activities one after the other.
        
        This example demonstrates some of the very basic Activity classes.
     
        The CodeActivity represents a "code-beside" method which is called through an event.
        The SequenceActivity is a list of other activities which are executed sequentially, one after the other.
        The DelayActivity is a delay devise which suspends workflow execution based on an 
        interval property.
 
     
     
     */
    public sealed partial class Workflow1: SequentialWorkflowActivity
	{
		public Workflow1()
		{
			InitializeComponent();

            //this.Delay
            this.Delay.Executing += new EventHandler<ActivityExecutionStatusChangedEventArgs>(Delay_Executing);
            this.Delay.Closed += new EventHandler<ActivityExecutionStatusChangedEventArgs>(Delay_Closed);
		}

        string userName;

        private void Code0_ExecuteCode(object sender, EventArgs e)
        {
            Console.WriteLine("Code0: What is your name?");
            userName = Console.ReadLine();
        }

        private void Code1_ExecuteCode(object sender, EventArgs e)
        {
            Console.WriteLine("Code1: Hello {0}!!!  Hit <ENTER> to continue...", userName);
            Console.ReadLine();      
        }

        private void anyCodeInSequence_ExecuteCode(object sender, EventArgs e)
        {
            Activity a = sender as Activity;
            Console.WriteLine(a.Name + ": Hit <ENTER> to continue...");
            Console.ReadLine();
        }

        private void Delay_Executing(object sender, ActivityExecutionStatusChangedEventArgs e)
        {
            Console.WriteLine("Delay starts executing...");
        }

        private void Delay_Closed(object sender, ActivityExecutionStatusChangedEventArgs e)
        {
            Console.WriteLine("Delay done executing...");
        }




	}

}
